<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://http://designingmedia.com/
 * @since      1.0.0
 *
 * @package    Akd_Demo_Importer
 * @subpackage Akd_Demo_Importer/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Akd_Demo_Importer
 * @subpackage Akd_Demo_Importer/admin
 * @author     Ammar Nasir <info@domain.com>
 */
class Akd_Demo_Importer_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Akd_Demo_Importer_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Akd_Demo_Importer_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/akd-demo-importer-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Akd_Demo_Importer_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Akd_Demo_Importer_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/akd-demo-importer-admin.js', array( 'jquery' ), $this->version, false );

	}

	public function pre($data){
		echo '<pre>'; print_r($data);
	}

	/**
	 * Method to trigger Merlin framework
	 */
	public function akd_merlin_init(){
		if ( is_admin() && current_user_can( 'manage_options' ) ) {
			if ( class_exists( 'Merlin' ) ) {
				$merlin = new Merlin(
					'medunit', // The unique ID of your theme or plugin
					'dashboard', // The admin page to redirect users to after onboarding is complete
					array(
						'override' => true, // Whether to override the existing onboarding configuration (if any)
					)
				);
			}
		}

		//cookie complaince plugin warning on merlin page
		if ( is_plugin_active( 'gdpr-cookie-compliance/moove-gdpr.php' ) ) {
			if(isset($_GET['page']) && $_GET['page'] === 'merlin'){
				$this->remove_class_action('gdpr_check_review_banner_condition', 'Moove_GDPR_Review', 'gdpr_check_review_banner_condition_func');
			}
		}
	}

	/**
	 * Method to import demo content files
	 */
	public function merlin_local_import_files() {

		$demo_directory = get_template_directory() . '/demo/';
		$demo_files = scandir($demo_directory);

		$import_config = array(
			'import_file_name'             => 'Demo Import',
			'import_notice'                => __( 'After you import this demo, you will have to setup the slider separately.', 'akd-demo-importer' ),
			'preview_url'                  => home_url( '/' ),
		);

		foreach ($demo_files as $file) {
			if ($file === '.' || $file === '..') {
				continue;
			}

			switch ($file) {
				case 'lawfinity-demo-content.xml':
					$import_config['local_import_file'] = $demo_directory . $file;
					break;
				case 'site-settings.json':
					$import_config['local_import_widget_file'] = $demo_directory . $file;
					break;
				case 'lawfinitycustomizer.dat':
					$import_config['local_import_customizer_file'] = $demo_directory . $file;
					break;
				// Add cases for other relevant files if needed
				default:
					// Handle other files if needed
					break;
			}
		}

		return [$import_config];
	}

	/**
	 * Method to remove specific action or filter
	 */
	public function remove_class_action ($action,$class,$method) {
		global $wp_filter ;
		if (isset($wp_filter[$action])) {
			$len = strlen($method) ;
			foreach ($wp_filter[$action] as $pri => $actions) {
				foreach ($actions as $name => $def) {
					if (substr($name,-$len) == $method) {
						if (is_array($def['function'])) {
							if (get_class($def['function'][0]) == $class) {
								if (is_object($wp_filter[$action]) && isset($wp_filter[$action]->callbacks)) {
									unset($wp_filter[$action]->callbacks[$pri][$name]) ;
								} else {
									unset($wp_filter[$action][$pri][$name]) ;
								}
							}
						}
					}
				}
			}
		}
	}

}
