<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://designingmedia.com/
 * @since             1.0.0
 * @package           Akd_Demo_Importer
 *
 * @wordpress-plugin
 * Plugin Name:       AKD Demo Importer
 * Plugin URI:        https://designingmedia.com/
 * Description:       This plugin will help you to import theme's demo content.
 * Version:           1.0.1
 * Author:            Ammar Nasir
 * Author URI:        https://designingmedia.com//
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       akd-demo-importer
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'AKD_DEMO_IMPORTER_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-akd-demo-importer-activator.php
 */
function activate_akd_demo_importer() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-akd-demo-importer-activator.php';
	Akd_Demo_Importer_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-akd-demo-importer-deactivator.php
 */
function deactivate_akd_demo_importer() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-akd-demo-importer-deactivator.php';
	Akd_Demo_Importer_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_akd_demo_importer' );
register_deactivation_hook( __FILE__, 'deactivate_akd_demo_importer' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-akd-demo-importer.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_akd_demo_importer() {

	$plugin = new Akd_Demo_Importer();
	$plugin->run();

}
run_akd_demo_importer();
