<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor banner Widget.
 *
 * Elementor widget that uses the banner control.
 *
 * @since 1.0.0
 */
class Elementor_Banner_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve banner widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'banner';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve banner widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Lawfinity Banner Slider', 'elementor-banner-control' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve banner widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel-loop';
	}

	/**
	 * Register banner widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'elementor-banner-control' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_content', [
				'label' => __( 'Content', 'elementor-banner-control' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Content' , 'elementor-banner-control' ),
				'label_block' => true,
				'show_label' => false,
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'Banner Content List', 'elementor-banner-control' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_content' => __( 'Content', 'elementor-banner-control' ),
					],
					[
						'list_content' => __( 'Content', 'elementor-banner-control' ),
					],
				],
			]
		);
	}


	/**
	 * Render banner widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
        <section class="banner-con position-relative">
                <div class="banner_content">
                    <div class="owl-carousel owl-theme">
                <?php
                if ($settings['list']) {
                    foreach ($settings['list'] as $item) {
                        ?>
                        <div class="item">
                                <h1 class="text-white mb-0"><?php echo $item['list_content']; ?></h1>
                        </div>
                        <?php
                    }
                }
                ?>
                    </div>
                </div>
        </section>
        <?php
	}
	
}