<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
 
/**
 * Elementor lawfinity-team Widget.
 *
 * Elementor widget that uses the lawfinity-team control.
 *
 * @since 1.0.0
 */
class Elementor_Lawfinity_Team_Widget extends \Elementor\Widget_Base
{
 
    /**
     * Get widget name.
     *
     * Retrieve lawfinity-team widget name.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'lawfinity-team';
    }
 
    /**
     * Get widget title.
     *
     * Retrieve lawfinity-team widget title.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title()
    {
        return esc_html__('Lawfinity Team', 'elementor-lawfinity-team-control');
    }
 
    /**
     * Get widget icon.
     *
     * Retrieve lawfinity-team widget icon.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-posts-grid';
    }
 
    /**
     * Register lawfinity-team widget controls.
     *
     * Add input fields to allow the user to customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
 
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'elementor-lawfinity-team-control'),
                'type' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'selected_members',
            [
                'label' => esc_html__('Select Members', 'elementor-lawfinity-team-control'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_teams_options(), // Define a function to get available services options
            ]
        );
        $this->add_control(
			'selected_style',
			[
				'label' => esc_html__( 'Select Style', 'elementor-lawfinity-team-control' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'style1', // Set the default style
				'options' => [
					'style1' => esc_html__( 'Style 1', 'elementor-lawfinity-team-control' ),
					'style2' => esc_html__( 'Style 2', 'elementor-lawfinity-team-control' ),
				],
			]
		);	
        $this->end_controls_section();
        $this->start_controls_section(
            'query_section',
            [
                'label' => esc_html__('Query Settings', 'elementor-lawfinity-team-control'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
 
        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('Order By', 'elementor-lawfinity-team-control'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'ID' => esc_html__('Post ID', 'elementor-lawfinity-team-control'),
                    'title' => esc_html__('Title', 'elementor-lawfinity-team-control'),
                    'date' => esc_html__('Date', 'elementor-lawfinity-team-control'),
                    // Add other options as needed
                ],
                'default' => 'ID', // Default order by Post ID
            ]
        );
 
        $this->add_control(
            'post_status',
            [
                'label' => esc_html__('Post Status', 'elementor-lawfinity-team-control'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'publish' => esc_html__('Publish', 'elementor-lawfinity-team-control'),
                    'draft' => esc_html__('Draft', 'elementor-lawfinity-team-control'),
                    // Add other options as needed
                ],
                'default' => 'publish', // Default post status is 'publish'
            ]
        );
 
        $this->add_control(
            'order',
            [
                'label' => esc_html__('Order', 'elementor-lawfinity-team-control'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__('Ascending', 'elementor-lawfinity-team-control'),
                    'DESC' => esc_html__('Descending', 'elementor-lawfinity-team-control'),
                ],
                'default' => 'ASC', // Default order is descending
            ]
        );
 
        $this->end_controls_section();
    }
 
    private function get_teams_options()
    {
        $options = [];
        $args = array(
            'post_type' => 'our_team',
            'posts_per_page' => -1,
            'post_status' => 'publish',
        );
        $services = new WP_Query($args);
 
        if ($services->have_posts()) {
            while ($services->have_posts()) {
                $services->the_post();
                $options[get_the_ID()] = get_the_title();
            }
            wp_reset_postdata();
        }
 
        return $options;
    }


    /**
     * Render lawfinity-team widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $selected_style = $settings['selected_style'];
        $selected_members = !empty($settings['selected_members']) ? $settings['selected_members'] : array(); // Check if team members are selected
    
        // If no team members are selected, fetch all team members
        if (empty($selected_members)) {
            $args = array(
                'post_type'      => 'our_team',
                'orderby'        => $this->get_settings('orderby'),
                'post_status'    => $this->get_settings('post_status'),
                'order'          => $this->get_settings('order'),
                'posts_per_page' => -1,
            );
    
            $result = new WP_Query($args);
        } else {
            $args = array(
                'post_type'      => 'our_team',
                'orderby'        => $this->get_settings('orderby'),
                'post_status'    => $this->get_settings('post_status'),
                'order'          => $this->get_settings('order'),
                'posts_per_page' => -1,
                'post__in'       => $selected_members, // Include only the selected services
            );
    
            $result = new WP_Query($args);
        }
    
        if ($selected_style === 'style1') {
            ?>
            <section class="lawyer-con position-relative">
                <div class="container">
                    <div class="row" data-aos="fade-up">
            <?php
            while ($result->have_posts()) {
                $result->the_post();
                $url = wp_get_attachment_url(get_post_thumbnail_id(), "post_thumbnail");
                $fb = get_post_meta(get_the_ID(), 'team_member_facebook_link', true);
                $twitter = get_post_meta(get_the_ID(), 'team_member_twitter_link', true);
                $instagram = get_post_meta(get_the_ID(), 'team_member_linkedin_link', true);
                ?>
                <div class="col-lg-4 col-md-4 col-sm-4 col-12">
                    <div class="lawyer-box">
                        <a href="<?php echo get_post_permalink(); ?>">
                            <figure class="lawyer-image">
                                <img src="<?php echo $url; ?>" alt="" class="img-fluid">
                            </figure>
                        </a>
                        <div class="content">
                            <a href="<?php echo get_post_permalink(); ?>"><h5><?php echo get_the_title(); ?></h5></a>
                            <span class="text-size-14"><?php echo get_the_excerpt(); ?></span>
                            <ul class="list-unstyled mb-0">
                                <?php
                                if ($fb) {
                                ?>
                                <li class="icons"><a href="<?php echo $fb ?>"><i class="fa-brands fa-facebook-f"></i></a></li>
                                <?php
                                }
                                if ($twitter) {
                                ?>
                                <li class="icons"><a href="<?php echo $twitter ?>"><i class="fa-brands fa-twitter"></i></a></li>
                                <?php
                                }
                                if ($instagram) {
                                ?>
                                <li class="icons"><a href="<?php echo $instagram ?>"><i class="fa-brands fa-linkedin"></i></a></li>
                                <?php
                                    }
                                ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <?php
            }
            echo '</div>';
            echo '</div>';
            echo '</section>';
        } elseif ($selected_style === 'style2') {?>
            <section class="lawyer-con legal_matter_lawyer position-relative">
                <div class="container">
                    <div class="row" data-aos="fade-up">
                <?php
                while ($result->have_posts()) {
                $result->the_post();
                $url = wp_get_attachment_url(get_post_thumbnail_id(), "post_thumbnail");
                $fb = get_post_meta(get_the_ID(), 'team_member_facebook_link', true);
                $twitter = get_post_meta(get_the_ID(), 'team_member_twitter_link', true);
                $instagram = get_post_meta(get_the_ID(), 'team_member_linkedin_link', true);
                ?>
                <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                    <div class="lawyer-box">
                        <a href="<?php echo get_post_permalink(); ?>"><figure class="lawyer-image">
                            <img src="<?php echo $url; ?>" alt="" class="img-fluid">
                        </figure></a>
                        <div class="content">
                            <h5><?php echo get_the_title(); ?></h5>
                            <span class="text-size-14"><?php echo get_the_excerpt(); ?></span>
                            <ul class="list-unstyled mb-0">
                                <?php
                                if ($fb) {
                                ?>
                                <li class="icons"><a href="<?php echo $fb ?>"><i class="fa-brands fa-facebook-f"></i></a></li>
                                <?php
                                }
                                if ($twitter) {
                                ?>
                                <li class="icons"><a href="<?php echo $twitter ?>"><i class="fa-brands fa-twitter"></i></a></li>
                                <?php
                                }
                                if ($instagram) {
                                ?>
                                <li class="icons"><a href="<?php echo $instagram ?>"><i class="fa-brands fa-linkedin"></i></a></li>
                                <?php
                                    }
                                ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <?php
            }
            echo '</div>';
            echo '</div>';
            echo '</section>';
                // Implement style 2 rendering logic here
        }
    }
    
}