<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package lawfinity
 */
?>  
    <?php
    if (have_posts()) {
        // Set the loop context to ensure proper global $post object
        while (have_posts()) {
            the_post(); // Ensure proper context
        }

        // Get the current page ID
        $current_page_id = get_the_ID();

    }
    if ($current_page_id) {
        // Check for a valid post ID before proceeding with Elementor code
        $elementor_document = \Elementor\Plugin::$instance->documents->get($current_page_id);
        
        // Theme mod values
        $lawfinity_footer_e = get_theme_mod('choose_elementor_footer');
        $lawfinity_footer_type = get_theme_mod('footer_source_type');
        
        // Default footer
        $page_footer = $lawfinity_footer_e;

        // Check if it's a valid Elementor document and if there's a footer set via Elementor settings
        if ($elementor_document instanceof \Elementor\Core\DocumentTypes\Page) {
            $page_settings = $elementor_document->get_settings();
            
            $show_page_footer = $page_settings['page_footer_display'] ?? false;
            $chosen_elementor_page_footer = $page_settings['choose_elementor_page_footer'] ?? null;
            
            if ($show_page_footer && !empty($chosen_elementor_page_footer)) {
                $page_footer = $chosen_elementor_page_footer;
            }

            // Display the correct footer content based on Elementor settings
            if ($show_page_footer) {
                echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display($page_footer);
            } else {
                echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display($lawfinity_footer_e);
            }
        } else {
            echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display($lawfinity_footer_e);
        }
    } else {
        // If the post ID is not valid, provide a fallback to avoid errors
        echo 'Invalid Post ID';
    }
    ?>

    
    <?php do_action('lawfinity_footer_style');  ?>
</div><!-- #page -->

    <?php 
wp_footer(); 
    ?>
    </body>
</html>