<?php
/** 
 * Lawfinity Customizer data
 */

function lawfinity_customizer( $data ) {
	$lawfinity_elementor_template_list = lawfinity_get_elementor_templates();
	$lawfinity_elementor_header_templates = lawfinity_get_elementor_header_templates();
	return array(
		'panel' => array ( 
			'id' => 'lawfinity',
			'name' => esc_html__('Lawfinity Customizer','lawfinity'),
			'priority' => 10,
			'section' => array(
				'header_setting' => array(
					'name' => esc_html__( 'Header Topbar Setting', 'lawfinity' ),
					'priority' => 10,
					'fields' => array(
						array(
							'name' => esc_html__( 'Topbar Swicher', 'lawfinity' ),
							'id' => 'lawfinity_topbar_switch',
							'default' => false,
							'type' => 'switch',
							'transport'	=> 'refresh'
						),						
						array(
							'name' => esc_html__( 'Show Button', 'lawfinity' ),
							'id' => 'lawfinity_show_header_btn',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Button Text', 'lawfinity' ),
							'id' => 'lawfinity_header_btn_text',
							'default' => esc_html__('Sign in','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Button Link', 'lawfinity' ),
							'id' => 'lawfinity_header_btn_link',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Button Icon', 'lawfinity' ),
							'id' => 'lawfinity_header_btn_icon',
							'default' => esc_html__('fa fa-user-o', 'lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						/** investment button **/	
						array(
							'name' => esc_html__( 'Show Investment Offer Link', 'lawfinity' ),
							'id' => 'lawfinity_show_investment_offer_link',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Link Text', 'lawfinity' ),
							'id' => 'lawfinity_header_link_text',
							'default' => esc_html__('Lawfinity Offer','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Link Url', 'lawfinity' ),
							'id' => 'lawfinity_header_link_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						/** contact-info **/
						array(
							'name' => esc_html__( 'Show Contact Info', 'lawfinity' ),
							'id' => 'lawfinity_show_contact_info',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Email Address', 'lawfinity' ),
							'id' => 'lawfinity_header_email',
							'default' => esc_html__('info@gmail.com','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Phone Number', 'lawfinity' ),
							'id' => 'lawfinity_header_phone',
							'default' => esc_html__('+97657945737', 'lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						)

					) 
				),
				'lawfinity_topbar_social_profiles_setting' => array(
					'name' => esc_html__( 'Header Social Profiles', 'lawfinity' ),
					'priority' => 15,
					'fields' => array(
						array(
							'name' => esc_html__( 'Show Social Profiles', 'lawfinity' ),
							'id' => 'lawfinity_show_social_profiles',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Facebook Url', 'lawfinity' ),
							'id' => 'lawfinity_topbar_fb_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Twitter Url', 'lawfinity' ),
							'id' => 'lawfinity_topbar_twitter_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Linkedin Url', 'lawfinity' ),
							'id' => 'lawfinity_topbar_linkedin_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Instagram Url', 'lawfinity' ),
							'id' => 'lawfinity_topbar_instagram_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
					) 
				),
				'header_main_setting' => array(
					'name' => esc_html__( 'Header Setting', 'lawfinity' ),
					'priority' => 20,
					'fields' => array(
						array(
							'name' => esc_html__( 'Choose Header Style', 'lawfinity' ),
							'id' => 'choose_default_header',
							'type'     => 'select',
							'choices'  => array(
								'header-style-1' => esc_html__( 'Header Style 1', 'lawfinity' ),
								'header-style-2' => esc_html__( 'Header Style 2', 'lawfinity' ),
							),
							'default' => 'header-style-2',
							'transport'	=> 'refresh'
						),
						array(
							'name' => esc_html__( 'Header Type', 'lawfinity' ),
							'id' => 'choose_default_header',
							'type'     => 'select',
							'choices'  => array(
								'default-header' => esc_html__( 'Default Header', 'lawfinity' ),
								'elementor-header' => esc_html__( 'Elementor Header', 'lawfinity' ),
							),
							'default' => 'default-header',
							'transport'	=> 'refresh'
						),
						array(
							'name' => esc_html__( 'Header Elementor Templates', 'lawfinity' ),
							'id' => 'choose_elementor_header',
							'type'     => 'select',
							'choices'  => $lawfinity_elementor_header_templates,
							'transport'	=> 'refresh',
							'required' => ['header_source_type',
							'=',
							'e'],
						),
						array(
							'name' => esc_html__( 'Header Logo', 'lawfinity' ),
							'id' => 'logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header Black Logo', 'lawfinity' ),
							'id' => 'seconday_logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo-black.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header Retina Logo', 'lawfinity' ),
							'id' => 'retina_logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo@2x.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header Retina Black Logo', 'lawfinity' ),
							'id' => 'retina_secondary_logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo-black@2x.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Show Header Search', 'lawfinity' ),
							'id' => 'lawfinity_header_search_show',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),	
					) 
				),	
				'banner_main_setting' => array(
					'name' => esc_html__( 'Sub Banner Setting', 'lawfinity' ),
					'priority' => 20,
					'fields' => array(
						
						array(
							'name' => esc_html__( 'Banner Image', 'lawfinity' ),
							'id' => 'sub-banner-img',
							'default' => get_template_directory_uri() . '/assets/img/sub-banner-img.jpg',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						
					) 
				),	
				'page_title_setting'=> array(
					'name'=> esc_html__('Page Title Setting','lawfinity'),
					'priority'=> 30,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Choose Breadcrumb Style', 'lawfinity' ),
							'id' => 'choose_default_breadcrumb',
							'type'     => 'select',
							'choices'  => array(
								'breadcrumb-style-1' => esc_html__( 'Breadcrumb Style 1', 'lawfinity' ),
								'breadcrumb-style-2' => esc_html__( 'default', 'lawfinity' ),
							),
							'default' => 'breadcrumb-style-1',
							'transport'	=> 'refresh'
						),
						array(
							'name'=>esc_html__('Breadcrumb BG Color','lawfinity'),
							'id'=>'breadcrumb_bg_color',
							'default'=> esc_html__('#343a40','lawfinity'),
							'transport'	=> 'refresh'  
						),
						array(
							'name' => esc_html__( 'Page Title Background Image', 'lawfinity' ),
							'id' => 'breadcrumb_bg_img',
							'default' => '',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb Archive', 'lawfinity' ),
							'id' => 'breadcrumb_archive',
							'default' => esc_html__('Archive for category','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb Search', 'lawfinity' ),
							'id' => 'breadcrumb_search',
							'default' => esc_html__('Search results for','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Breadcrumb tagged', 'lawfinity' ),
							'id' => 'breadcrumb_post_tags',
							'default' => esc_html__('Posts tagged','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb posted by', 'lawfinity' ),
							'id' => 'breadcrumb_artitle_post_by',
							'default' => esc_html__('Articles posted by','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb Page Not Found', 'lawfinity' ),
							'id' => 'breadcrumb_404',
							'default' => esc_html__('Page Not Found','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),		
						array(
							'name' => esc_html__( 'Breadcrumb Page', 'lawfinity' ),
							'id' => 'breadcrumb_page',
							'default' => esc_html__('Page','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),			
						array(
							'name' => esc_html__( 'Breadcrumb Shop', 'lawfinity' ),
							'id' => 'breadcrumb_shop',
							'default' => esc_html__('Shop','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),			
						array(
							'name' => esc_html__( 'Breadcrumb Home', 'lawfinity' ),
							'id' => 'breadcrumb_home',
							'default' => esc_html__('Home','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),					
					)
				),
				'blog_setting'=> array(
					'name'=> esc_html__('Blog Setting','lawfinity'),
					'priority'=> 40,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Show Blog BTN', 'lawfinity' ),
							'id' => 'lawfinity_blog_btn_switch',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Show Blog Btn Icon', 'lawfinity' ),
							'id' => 'lawfinity_blog_btn_icon_switch',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Blog Button text', 'lawfinity' ),
							'id' => 'lawfinity_blog_btn',
							'default' => esc_html__('Read More','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),							
						array(
							'name' => esc_html__( 'Blog Button Icon', 'lawfinity' ),
							'id' => 'lawfinity_blog_btn_icon',
							'default' => esc_html__('fas fa-angle-double-right','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Blog Title', 'lawfinity' ),
							'id' => 'breadcrumb_blog_title',
							'default' => esc_html__('Blog','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Blog Details Title', 'lawfinity' ),
							'id' => 'breadcrumb_blog_title_details',
							'default' => esc_html__('Blog Details','lawfinity'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),

					)
				),
				'lawfinity_footer_setting' => array(
					'name'=> esc_html__('Footer Setting','lawfinity'),
					'priority'=> 60,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Footer Elementor Templates', 'lawfinity' ),
							'id' => 'choose_elementor_footer',
							'type'     => 'select',
							'choices'  => $lawfinity_elementor_template_list,
							'transport'	=> 'refresh',
							'required' => ['footer_source_type',
							'=',
							'e'],
						),
						array(
							'name' => esc_html__( 'Choose Footer Style', 'lawfinity' ),
							'id' => 'choose_default_footer',
							'type'     => 'select',
							'choices'  => array(
								'footer-style-1' => esc_html__( 'Footer Style 1', 'lawfinity' ),
								'footer-style-2' => esc_html__( 'Footer Style 2', 'lawfinity' ),
								'footer-style-3' => esc_html__( 'Footer Style 3', 'lawfinity' ),
							),
							'default' => 'footer-style-1',
							'transport'	=> 'refresh'
						),
						array(
							'name' => esc_html__( 'Footer Background Image', 'lawfinity' ),
							'id' => 'lawfinity_footer_bg',
							'default' => '',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name'=>esc_html__('Footer BG Color','lawfinity'),
							'id'=>'lawfinity_footer_bg_color',
							'default'=> esc_html__('#f4f9fc','lawfinity'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Copy Right','lawfinity'),
							'id'=>'lawfinity_copyright',
							'default'=> esc_html__('Copyright &copy; Lawfinity 2023. All rights reserved','lawfinity'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),	
						array(
							'name'=>esc_html__('Enable Scrollup','lawfinity'),
							'id'=>'lawfinity_scrollup_switch',
							'default'=> false,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						),						
						array(
							'name'=>esc_html__('Enable Footer Widgets','lawfinity'),
							'id'=>'lawfinity_enable_footer_widgets',
							'default'=> true,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						),	
						array(
							'name'=>esc_html__('Enable Preloader','lawfinity'),
							'id'=>'lawfinity_preloader_switch',
							'default'=> false,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						)
					)
				),
				'error_page_setting'=> array(
					'name'=> esc_html__('404 Setting','lawfinity'),
					'priority'=> 90,
					'fields'=> array(
						array(
							'name'=>esc_html__('400 Text','lawfinity'),
							'id'=>'lawfinity_error_404_text',
							'default'=> esc_html__('404','lawfinity'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Not Found Title','lawfinity'),
							'id'=>'lawfinity_error_title',
							'default'=> esc_html__('Page not found','lawfinity'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('404 Description Text','lawfinity'),
							'id'=>'lawfinity_error_desc',
							'default'=> esc_html__('Oops! The page you are looking for does not exist. It might have been moved or deleted','lawfinity'),
							'type'=>'textarea',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('404 Link Text','lawfinity'),
							'id'=>'lawfinity_error_link_text',
							'default'=> esc_html__('Back To Home','lawfinity'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						)
						
					)
				),
			),
		)
	);

}

add_filter('lawfinity_customizer_data', 'lawfinity_customizer');


